<?php
$person = isset($attributes['person']) ? esc_html($attributes['person']) : '';
$workSection = isset($attributes['workSection']) ? esc_html($attributes['workSection']) : '';
$workName = isset($attributes['workName']) ? esc_html($attributes['workName']) : '';
$workAuthor = isset($attributes['workAuthor']) ? esc_html($attributes['workAuthor']) : '';
$workUrl = isset($attributes['workUrl']) ? esc_url($attributes['workUrl']) : '';

$quote_text = $content;
?>

<figure class="wp-cited-quote">
    <blockquote class="wp-cited-quote-text">
        <?php echo $quote_text; ?>
    </blockquote>
    
    <?php if ($person || $workSection || $workName || $workAuthor): ?>
        <figcaption class="wp-cited-quote-attribution">
            <?php
            $parts = [];
            
            if ($person) {
                $parts[] = '<span class="wp-cited-quote-person">' . $person . '</span>';
            }
            
            if ($workSection) {
                $parts[] = '<span class="wp-cited-quote-work-section">' . $workSection . '</span>';
            }
            
            if ($workName) {
                $work_html = '<cite class="wp-cited-quote-work">';
                if ($workUrl) {
                    $work_html .= '<a class="wp-cited-quote-url" href="' . $workUrl . '"><i>' . $workName . '</i></a>';
                } else {
                    $work_html .= '<i>' . $workName . '</i>';
                }
                $work_html .= '</cite>';
                $parts[] = $work_html;
            }
            
            if ($workAuthor) {
                $parts[] = 'by <span class="wp-cited-quote-work-author">' . $workAuthor . '</span>';
            }
            
            echo implode(', ', $parts);
            ?>
        </figcaption>
    <?php endif; ?>
</figure>