(function(blocks, element, blockEditor, components) {
    const el = element.createElement;
    const { registerBlockType } = blocks;
    const { InnerBlocks, InspectorControls, BlockControls } = blockEditor;
    const { PanelBody, TextControl, ToolbarGroup, ToolbarButton, Popover } = components;
    const { useState } = element;
    
    registerBlockType('cited-quote/block', {
        edit: function(props) {
            const { attributes, setAttributes } = props;
            const [showPopover, setShowPopover] = useState(false);
            const [popoverAnchor, setPopoverAnchor] = useState(null);
            
            return el('div', {},
                el(BlockControls, {},
                    el(ToolbarGroup, {},
                        el(ToolbarButton, {
                            icon: 'edit',
                            label: 'Edit Citation',
                            onClick: function(event) {
                                setPopoverAnchor(event.currentTarget);
                                setShowPopover(!showPopover);
                            },
                            isPressed: showPopover
                        })
                    )
                ),
                showPopover && el(Popover, {
                    anchor: popoverAnchor,
                    onClose: function() {
                        setShowPopover(false);
                    },
                    placement: 'bottom-start'
                },
                    el('div', { style: { padding: '16px', width: '300px' } },
                        el('h3', { style: { marginTop: 0, marginBottom: '12px', fontSize: '13px', fontWeight: 600 } }, 'Citation Details'),
                        el(TextControl, {
                            label: 'Person (optional)',
                            value: attributes.person,
                            onChange: function(value) {
                                setAttributes({ person: value });
                            },
                            style: { marginBottom: '12px' }
                        }),
                        el(TextControl, {
                            label: 'Work Section (optional)',
                            value: attributes.workSection,
                            onChange: function(value) {
                                setAttributes({ workSection: value });
                            },
                            style: { marginBottom: '12px' }
                        }),
                        el(TextControl, {
                            label: 'Work Name (required)',
                            value: attributes.workName,
                            onChange: function(value) {
                                setAttributes({ workName: value });
                            },
                            style: { marginBottom: '12px' }
                        }),
                        el(TextControl, {
                            label: 'Work Author (required)',
                            value: attributes.workAuthor,
                            onChange: function(value) {
                                setAttributes({ workAuthor: value });
                            },
                            style: { marginBottom: '12px' }
                        }),
                        el(TextControl, {
                            label: 'Work URL (optional)',
                            value: attributes.workUrl,
                            onChange: function(value) {
                                setAttributes({ workUrl: value });
                            }
                        })
                    )
                ),
                el(InspectorControls, {},
                    el(PanelBody, { title: 'Citation Details', initialOpen: true },
                        el(TextControl, {
                            label: 'Person (optional)',
                            value: attributes.person,
                            onChange: function(value) {
                                setAttributes({ person: value });
                            }
                        }),
                        el(TextControl, {
                            label: 'Work Section (optional)',
                            value: attributes.workSection,
                            onChange: function(value) {
                                setAttributes({ workSection: value });
                            }
                        }),
                        el(TextControl, {
                            label: 'Work Name (required)',
                            value: attributes.workName,
                            onChange: function(value) {
                                setAttributes({ workName: value });
                            }
                        }),
                        el(TextControl, {
                            label: 'Work Author (required)',
                            value: attributes.workAuthor,
                            onChange: function(value) {
                                setAttributes({ workAuthor: value });
                            }
                        }),
                        el(TextControl, {
                            label: 'Work URL (optional)',
                            value: attributes.workUrl,
                            onChange: function(value) {
                                setAttributes({ workUrl: value });
                            }
                        })
                    )
                ),
                el('figure', { className: 'wp-cited-quote', style: { border: '1px dashed lightgray', padding: '20px' } },
                    el('blockquote', { className: 'wp-cited-quote-text' },
                        el(InnerBlocks, {
                            allowedBlocks: ['core/paragraph', 'core/heading', 'core/list'],
                            template: [['core/paragraph', { placeholder: 'Enter quote text...' }]]
                        })
                    ),
                    (attributes.person || attributes.workName || attributes.workAuthor) && 
                    el('figcaption', { className: 'wp-cited-quote-attribution', style: { marginTop: '10px', fontStyle: 'italic' } },
                        [
                            attributes.person && el('span', {}, attributes.person),
                            attributes.person && (attributes.workSection || attributes.workName) && ', ',
                            attributes.workSection && el('span', {}, attributes.workSection),
                            attributes.workSection && attributes.workName && ', ',
                            attributes.workName && el('cite', {}, el('i', {}, attributes.workName)),
                            attributes.workAuthor && ' by ',
                            attributes.workAuthor && el('span', {}, attributes.workAuthor)
                        ]
                    )
                )
            );
        },
        save: function() {
            return el(InnerBlocks.Content);
        }
    });
})(
    window.wp.blocks,
    window.wp.element,
    window.wp.blockEditor,
    window.wp.components
);